"use client"

import { useState } from "react"
import { Button } from "@/components/ui/button"
import { Card, CardContent } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { MessageCircle, Clock, Star, Zap } from "lucide-react"

const advisors = [
  {
    id: 1,
    name: "Carlos Rodríguez",
    specialty: "Baterías Premium",
    phone: "573001234567",
    status: "online",
    rating: 4.9,
    responseTime: "< 2 min",
    image: "/professional-automotive-advisor-male.jpg",
  },
  {
    id: 2,
    name: "María González",
    specialty: "Baterías Económicas",
    phone: "573007654321",
    status: "online",
    rating: 4.8,
    responseTime: "< 3 min",
    image: "/professional-automotive-advisor-female.jpg",
  },
  {
    id: 3,
    name: "Juan Pérez",
    specialty: "Baterías Industriales",
    phone: "573009876543",
    status: "online",
    rating: 4.9,
    responseTime: "< 1 min",
    image: "/professional-automotive-advisor-male-industrial.jpg",
  },
]

export function WhatsAppAdvisors() {
  const [selectedAdvisor, setSelectedAdvisor] = useState<number | null>(null)

  const handleWhatsAppClick = (phone: string, name: string) => {
    const message = encodeURIComponent(
      `¡Hola ${name}! 👋 Estoy interesado en cotizar una batería para mi vehículo. ¿Podrías ayudarme con información y precios? 🚗🔋`,
    )
    window.open(`https://wa.me/${phone}?text=${message}`, "_blank")
  }

  return (
    <section className="py-16 bg-gradient-to-br from-orange-50 to-amber-50">
      <div className="container mx-auto px-4">
        <div className="text-center mb-12">
          <Badge className="mb-4 bg-primary text-primary-foreground pulse-glow">
            <Zap className="w-4 h-4 mr-2" />
            ASESORES EN LÍNEA
          </Badge>
          <h2 className="text-4xl font-bold mb-4 gradient-text">¡Habla Directamente con Nuestros Expertos!</h2>
          <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
            Obtén tu cotización personalizada al instante. Nuestros asesores están listos para ayudarte 24/7
          </p>
        </div>

        <div className="grid md:grid-cols-3 gap-6 max-w-5xl mx-auto">
          {advisors.map((advisor) => (
            <Card
              key={advisor.id}
              className={`relative overflow-hidden transition-all duration-300 hover:scale-105 hover:shadow-2xl cursor-pointer ${
                selectedAdvisor === advisor.id ? "ring-4 ring-primary shadow-2xl" : ""
              }`}
              onClick={() => setSelectedAdvisor(advisor.id)}
            >
              <CardContent className="p-6 text-center">
                <div className="relative mb-4">
                  <img
                    src={advisor.image || "/placeholder.svg"}
                    alt={advisor.name}
                    className="w-20 h-20 rounded-full mx-auto border-4 border-primary"
                  />
                  <div className="absolute -top-1 -right-1 w-6 h-6 bg-green-500 rounded-full border-2 border-white animate-pulse"></div>
                </div>

                <h3 className="text-xl font-bold mb-2">{advisor.name}</h3>
                <p className="text-primary font-semibold mb-3">{advisor.specialty}</p>

                <div className="flex items-center justify-center gap-4 mb-4 text-sm text-muted-foreground">
                  <div className="flex items-center gap-1">
                    <Star className="w-4 h-4 fill-yellow-400 text-yellow-400" />
                    <span>{advisor.rating}</span>
                  </div>
                  <div className="flex items-center gap-1">
                    <Clock className="w-4 h-4" />
                    <span>{advisor.responseTime}</span>
                  </div>
                </div>

                <Button
                  onClick={(e) => {
                    e.stopPropagation()
                    handleWhatsAppClick(advisor.phone, advisor.name)
                  }}
                  className="w-full bg-green-600 hover:bg-green-700 text-white font-bold py-3 pulse-glow"
                >
                  <MessageCircle className="w-5 h-5 mr-2" />
                  Chatear por WhatsApp
                </Button>
              </CardContent>
            </Card>
          ))}
        </div>

        <div className="text-center mt-12">
          <div className="bg-primary/10 rounded-2xl p-6 max-w-2xl mx-auto">
            <h3 className="text-2xl font-bold mb-3 text-primary">🚀 ¡Respuesta Inmediata Garantizada!</h3>
            <p className="text-lg">
              Todos nuestros asesores están capacitados para brindarte la mejor atención y los precios más competitivos
              del mercado
            </p>
          </div>
        </div>
      </div>
    </section>
  )
}
