"use client"

import { useState, useEffect } from "react"
import { Button } from "@/components/ui/button"
import { Card, CardContent } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { MessageCircle, Flame, Zap, Clock, Star } from "lucide-react"

const offers = [
  {
    id: 1,
    title: "BATERÍA PREMIUM LTH",
    originalPrice: 450000,
    discountPrice: 320000,
    discount: 30,
    image: "/premium-lth-car-battery.jpg",
    features: ["2 años garantía", "Instalación gratis", "Potencia máxima"],
    stock: 5,
    whatsappMessage:
      "¡Hola! Quiero aprovechar la oferta de la BATERÍA PREMIUM LTH con 30% de descuento. ¿Está disponible?",
  },
  {
    id: 2,
    title: "BATERÍA ECONÓMICA MAC",
    originalPrice: 280000,
    discountPrice: 210000,
    discount: 25,
    image: "/economic-mac-car-battery.jpg",
    features: ["1 año garantía", "Instalación incluida", "Excelente calidad"],
    stock: 3,
    whatsappMessage:
      "¡Hola! Me interesa la BATERÍA ECONÓMICA MAC con 25% de descuento. ¿Pueden confirmar disponibilidad?",
  },
  {
    id: 3,
    title: "BATERÍA INDUSTRIAL BOSCH",
    originalPrice: 650000,
    discountPrice: 520000,
    discount: 20,
    image: "/industrial-bosch-car-battery-heavy-duty.jpg",
    features: ["3 años garantía", "Uso industrial", "Máxima durabilidad"],
    stock: 2,
    whatsappMessage: "¡Hola! Necesito cotizar la BATERÍA INDUSTRIAL BOSCH con descuento. ¿Está en stock?",
  },
]

export function UrgentOffers() {
  const [timeLeft, setTimeLeft] = useState(3600) // 1 hora en segundos

  useEffect(() => {
    const timer = setInterval(() => {
      setTimeLeft((prev) => (prev > 0 ? prev - 1 : 3600))
    }, 1000)

    return () => clearInterval(timer)
  }, [])

  const formatTime = (seconds: number) => {
    const hours = Math.floor(seconds / 3600)
    const minutes = Math.floor((seconds % 3600) / 60)
    const secs = seconds % 60
    return `${hours.toString().padStart(2, "0")}:${minutes.toString().padStart(2, "0")}:${secs.toString().padStart(2, "0")}`
  }

  const handleWhatsAppClick = (message: string) => {
    const encodedMessage = encodeURIComponent(message)
    window.open(`https://wa.me/573001234567?text=${encodedMessage}`, "_blank")
  }

  return (
    <section className="py-16 bg-gradient-to-br from-red-600 via-orange-600 to-yellow-500">
      <div className="container mx-auto px-4">
        <div className="text-center mb-12">
          <Badge className="mb-4 bg-yellow-400 text-black font-bold text-lg px-6 py-2 pulse-glow">
            <Flame className="w-5 h-5 mr-2" />
            ¡OFERTAS RELÁMPAGO!
          </Badge>

          <h2 className="text-5xl font-black text-white mb-4">🔥 ¡ÚLTIMAS HORAS! 🔥</h2>

          <div className="bg-black/30 backdrop-blur-sm rounded-2xl p-6 max-w-md mx-auto border border-white/20">
            <p className="text-white text-xl font-bold mb-2">⏰ OFERTA TERMINA EN:</p>
            <div className="text-4xl font-black text-yellow-300">{formatTime(timeLeft)}</div>
          </div>
        </div>

        <div className="grid md:grid-cols-3 gap-8 max-w-6xl mx-auto">
          {offers.map((offer) => (
            <Card
              key={offer.id}
              className="relative overflow-hidden bg-white shadow-2xl hover:scale-105 transition-all duration-300 bounce-in"
            >
              {/* Badge de descuento */}
              <div className="absolute top-4 right-4 z-10">
                <Badge className="bg-red-600 text-white font-bold text-lg px-3 py-1 rotate-12 pulse-glow">
                  -{offer.discount}%
                </Badge>
              </div>

              {/* Badge de stock limitado */}
              <div className="absolute top-4 left-4 z-10">
                <Badge className="bg-orange-500 text-white font-bold px-3 py-1 shake">
                  <Zap className="w-4 h-4 mr-1" />
                  Solo {offer.stock}
                </Badge>
              </div>

              <CardContent className="p-6">
                <div className="text-center mb-6">
                  <img
                    src={offer.image || "/placeholder.svg"}
                    alt={offer.title}
                    className="w-32 h-32 mx-auto mb-4 object-contain"
                  />
                  <h3 className="text-xl font-bold mb-2">{offer.title}</h3>
                </div>

                <div className="text-center mb-6">
                  <div className="text-sm text-gray-500 line-through">${offer.originalPrice.toLocaleString()}</div>
                  <div className="text-3xl font-black text-primary">${offer.discountPrice.toLocaleString()}</div>
                  <div className="text-green-600 font-bold">
                    ¡Ahorras ${(offer.originalPrice - offer.discountPrice).toLocaleString()}!
                  </div>
                </div>

                <div className="space-y-2 mb-6">
                  {offer.features.map((feature, index) => (
                    <div key={index} className="flex items-center gap-2 text-sm">
                      <Star className="w-4 h-4 text-yellow-500 fill-current" />
                      <span>{feature}</span>
                    </div>
                  ))}
                </div>

                <Button
                  onClick={() => handleWhatsAppClick(offer.whatsappMessage)}
                  className="w-full bg-green-600 hover:bg-green-700 text-white font-bold py-4 text-lg pulse-glow"
                >
                  <MessageCircle className="w-5 h-5 mr-2" />
                  ¡COMPRAR AHORA!
                </Button>

                <div className="text-center mt-3 text-sm text-gray-600">
                  <Clock className="w-4 h-4 inline mr-1" />
                  Respuesta inmediata por WhatsApp
                </div>
              </CardContent>
            </Card>
          ))}
        </div>

        <div className="text-center mt-12">
          <div className="bg-yellow-400 text-black rounded-2xl p-6 max-w-2xl mx-auto">
            <h3 className="text-2xl font-black mb-2">⚡ ¡NO ESPERES MÁS! ⚡</h3>
            <p className="text-lg font-bold">
              Estas ofertas son por tiempo limitado. ¡Contacta ahora y asegura tu batería al mejor precio!
            </p>
          </div>
        </div>
      </div>
    </section>
  )
}
