"use client"

import { useState, useEffect } from "react"
import { Button } from "@/components/ui/button"
import { MessageCircle, X, Zap } from "lucide-react"

export function FloatingWhatsApp() {
  const [isOpen, setIsOpen] = useState(false)
  const [isVisible, setIsVisible] = useState(true)

  useEffect(() => {
    const timer = setInterval(() => {
      setIsVisible((prev) => !prev)
    }, 3000)

    return () => clearInterval(timer)
  }, [])

  const quickMessages = [
    {
      text: "💰 Cotizar Batería",
      message: "¡Hola! Quiero cotizar una batería para mi vehículo. ¿Podrían ayudarme con precios y disponibilidad?",
    },
    {
      text: "🔧 Soporte Técnico",
      message: "Necesito ayuda técnica con mi batería. ¿Pueden asesorarme?",
    },
    {
      text: "🚚 Instalación a Domicilio",
      message: "¿Ofrecen servicio de instalación a domicilio? Me interesa conocer los costos.",
    },
    {
      text: "⚡ Ofertas Especiales",
      message: "¿Tienen ofertas especiales o descuentos disponibles en baterías?",
    },
  ]

  const handleQuickMessage = (message: string) => {
    const phone = "573001234567" // Número principal
    const encodedMessage = encodeURIComponent(message)
    window.open(`https://wa.me/${phone}?text=${encodedMessage}`, "_blank")
    setIsOpen(false)
  }

  return (
    <div className="fixed bottom-6 right-6 z-50">
      {isOpen && (
        <div className="mb-4 bg-white rounded-2xl shadow-2xl border border-gray-200 p-4 w-80 bounce-in">
          <div className="flex items-center justify-between mb-4">
            <h3 className="font-bold text-lg text-primary">¡Hablemos por WhatsApp!</h3>
            <Button variant="ghost" size="sm" onClick={() => setIsOpen(false)} className="h-8 w-8 p-0">
              <X className="w-4 h-4" />
            </Button>
          </div>

          <div className="space-y-2">
            {quickMessages.map((item, index) => (
              <Button
                key={index}
                variant="outline"
                className="w-full justify-start text-left h-auto p-3 hover:bg-green-50 hover:border-green-300 bg-transparent"
                onClick={() => handleQuickMessage(item.message)}
              >
                {item.text}
              </Button>
            ))}
          </div>

          <div className="mt-4 text-center">
            <p className="text-sm text-muted-foreground">⚡ Respuesta en menos de 2 minutos</p>
          </div>
        </div>
      )}

      <Button
        onClick={() => setIsOpen(!isOpen)}
        className={`h-16 w-16 rounded-full bg-green-600 hover:bg-green-700 shadow-2xl transition-all duration-300 ${
          isVisible ? "pulse-glow shake" : ""
        }`}
      >
        <MessageCircle className="w-8 h-8 text-white" />
      </Button>

      {!isOpen && (
        <div className="absolute -top-12 -left-20 bg-primary text-primary-foreground px-3 py-1 rounded-full text-sm font-bold whitespace-nowrap bounce-in">
          <Zap className="w-4 h-4 inline mr-1" />
          ¡Cotiza Ahora!
        </div>
      )}
    </div>
  )
}
