"use client"

import { useState, useEffect } from "react"
import { Button } from "@/components/ui/button"
import { Badge } from "@/components/ui/badge"
import { MessageCircle, Zap, Clock, Shield, Award } from "lucide-react"

export function ExcitingHero() {
  const [timeLeft, setTimeLeft] = useState({
    hours: 23,
    minutes: 45,
    seconds: 30,
  })

  useEffect(() => {
    const timer = setInterval(() => {
      setTimeLeft((prev) => {
        if (prev.seconds > 0) {
          return { ...prev, seconds: prev.seconds - 1 }
        } else if (prev.minutes > 0) {
          return { ...prev, minutes: prev.minutes - 1, seconds: 59 }
        } else if (prev.hours > 0) {
          return { hours: prev.hours - 1, minutes: 59, seconds: 59 }
        }
        return { hours: 23, minutes: 59, seconds: 59 }
      })
    }, 1000)

    return () => clearInterval(timer)
  }, [])

  const handleWhatsAppClick = () => {
    const message = encodeURIComponent(
      "🚗⚡ ¡Hola! Quiero aprovechar la OFERTA ESPECIAL de baterías. ¿Pueden darme información sobre precios y disponibilidad? ¡Estoy listo para comprar HOY!",
    )
    window.open(`https://wa.me/573001234567?text=${message}`, "_blank")
  }

  return (
    <section className="relative min-h-screen bg-gradient-to-br from-orange-600 via-red-500 to-pink-600 overflow-hidden">
      {/* Elementos decorativos animados */}
      <div className="absolute inset-0">
        <div className="absolute top-20 left-10 w-32 h-32 bg-yellow-400 rounded-full opacity-20 animate-bounce"></div>
        <div className="absolute top-40 right-20 w-24 h-24 bg-white rounded-full opacity-30 animate-pulse"></div>
        <div className="absolute bottom-20 left-1/4 w-16 h-16 bg-orange-300 rounded-full opacity-25 animate-ping"></div>
      </div>

      <div className="relative container mx-auto px-4 py-20">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          {/* Contenido principal */}
          <div className="text-white space-y-8">
            <div className="space-y-4">
              <Badge className="bg-yellow-400 text-black font-bold px-4 py-2 text-lg pulse-glow">
                <Zap className="w-5 h-5 mr-2" />
                ¡OFERTA LIMITADA!
              </Badge>

              <h1 className="text-6xl lg:text-7xl font-black leading-tight">
                <span className="block">¡BATERÍAS</span>
                <span className="block text-yellow-300 gradient-text">PREMIUM</span>
                <span className="block">AL MEJOR</span>
                <span className="block text-yellow-300">PRECIO!</span>
              </h1>
            </div>

            <div className="bg-black/30 backdrop-blur-sm rounded-2xl p-6 border border-white/20">
              <h3 className="text-2xl font-bold mb-4 text-yellow-300">⏰ ¡OFERTA TERMINA EN:</h3>
              <div className="flex gap-4 justify-center lg:justify-start">
                <div className="text-center">
                  <div className="bg-white text-black text-3xl font-black px-4 py-2 rounded-lg">
                    {timeLeft.hours.toString().padStart(2, "0")}
                  </div>
                  <div className="text-sm mt-1">HORAS</div>
                </div>
                <div className="text-center">
                  <div className="bg-white text-black text-3xl font-black px-4 py-2 rounded-lg">
                    {timeLeft.minutes.toString().padStart(2, "0")}
                  </div>
                  <div className="text-sm mt-1">MIN</div>
                </div>
                <div className="text-center">
                  <div className="bg-white text-black text-3xl font-black px-4 py-2 rounded-lg">
                    {timeLeft.seconds.toString().padStart(2, "0")}
                  </div>
                  <div className="text-sm mt-1">SEG</div>
                </div>
              </div>
            </div>

            <div className="space-y-4">
              <Button
                onClick={handleWhatsAppClick}
                className="w-full lg:w-auto bg-green-600 hover:bg-green-700 text-white font-black text-xl px-12 py-6 rounded-2xl pulse-glow shake"
              >
                <MessageCircle className="w-8 h-8 mr-3" />
                ¡COTIZAR POR WHATSAPP AHORA!
              </Button>

              <div className="flex flex-wrap gap-4 text-sm">
                <div className="flex items-center gap-2">
                  <Clock className="w-5 h-5 text-yellow-300" />
                  <span>Respuesta en 2 min</span>
                </div>
                <div className="flex items-center gap-2">
                  <Shield className="w-5 h-5 text-yellow-300" />
                  <span>Garantía 2 años</span>
                </div>
                <div className="flex items-center gap-2">
                  <Award className="w-5 h-5 text-yellow-300" />
                  <span>Instalación gratis</span>
                </div>
              </div>
            </div>
          </div>

          {/* Imagen del producto */}
          <div className="relative">
            <div className="relative z-10 bounce-in">
              <img
                src="/premium-car-battery-with-lightning-effects-dramati.jpg"
                alt="Batería Premium"
                className="w-full max-w-lg mx-auto drop-shadow-2xl"
              />
            </div>

            {/* Efectos visuales */}
            <div className="absolute inset-0 bg-gradient-to-r from-yellow-400 to-orange-500 rounded-full blur-3xl opacity-30 animate-pulse"></div>

            {/* Badges flotantes */}
            <div className="absolute top-10 -left-10 bg-yellow-400 text-black font-bold px-4 py-2 rounded-full rotate-12 bounce-in">
              🔥 ¡MÁS VENDIDA!
            </div>
            <div className="absolute bottom-10 -right-10 bg-green-500 text-white font-bold px-4 py-2 rounded-full -rotate-12 bounce-in">
              ⚡ POTENCIA MÁXIMA
            </div>
          </div>
        </div>

        {/* Estadísticas impactantes */}
        <div className="mt-20 grid grid-cols-2 lg:grid-cols-4 gap-6">
          {[
            { number: "50K+", label: "Clientes Satisfechos" },
            { number: "24/7", label: "Atención WhatsApp" },
            { number: "2 Años", label: "Garantía Total" },
            { number: "30 Min", label: "Instalación Express" },
          ].map((stat, index) => (
            <div key={index} className="text-center text-white">
              <div className="text-4xl font-black text-yellow-300">{stat.number}</div>
              <div className="text-sm font-semibold">{stat.label}</div>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
